 ; Ŀ
 ;   Brac - Bracket drawer by half outline.                                
 ;   Brc - Bracket drawer by baseline and direction.                       
 ;   Copyright 1993, 2005, 2007, 2010 by Rocket Software Ltd.              
 ;   This code is not commented - I have only a vague idea how it works.   
 ;   Later: Brc is well commented, Brac less so.                           
 ; 

 ; Ŀ
 ;   Goto - grdraw an arrow.                                               
 ;   Arguments: bb, the start end of the arrow                             
 ;              aa, the point to which the arrow points.                   
 ;              colo, the arrow colour.                                    
 ;              hi, highlight the arrow if /= 0.                           
 ;   Notes:                                                                
 ;   1. any negative colour is equivalent to xor colour - dashed white -   
 ;      which erases itself on overwrite.                                  
 ;   2. 0 erases whatever is under it, and is undocumented.                
 ;   3. Highlighting must be turned on in the first grdraw call in the     
 ;      routine, and can't be turned off in the routine.                   
 ;   These may just be anomalies in this video system.                     
 ; 
 (DEFUN GOTO (bb aa colo hi / rad basic dist bhasic ang pa pb1 pb2)
  (setq rad (/ (getvar "viewsize") 20))
  (setq basic (/ (setq dist (distance aa bb)) 4))
  (if (> basic rad) (setq basic rad))
  (if (> basic (* dist 0.75)) (setq basic (* dist 0.75)))
  (setq bhasic (/ basic 2.25))
  (setq ang (angle aa bb))
  (setq pa (polar aa ang basic))
  (setq pb1 (polar pa (+ ang (/ pi 2)) bhasic))
  (setq pb2 (polar pa (+ ang (* pi 1.5)) bhasic))
  (grdraw aa pb1 colo hi) ; hilight must be in first call, doesn't turn off
  (grdraw pb1 pb2 colo)
  (grdraw aa pb2 colo)
  (grdraw bb pa colo)
 (princ))
 ; Ŀ
 ;   Goto end.                                                             
 ; 

 ; Ŀ
 ;   Olaf - make a ring of stars.                                          
 ;   Arguments: Pa, the circle centre.                                     
 ;              Rad, the circle radius.                                    
 ;              Stsz, star size as a fraction of circle radius.            
 ;              Angg, the starting circle rotation.                        
 ;              Colo, the starting star colour.                            
 ;              Numa, the number of stars.                                 
 ;   Calls Sta.  Returns nothing.                                          
 ; 
 (DEFUN OLAF (pa rad stsz angg colo numa / colo1 vsize angg rad pa2)
  (setq colo1 colo)
  (repeat numa
         (setq pa2 (polar pa angg rad))
         (sta pa2 (* rad stsz) (- angg (/ pi 2)) colo)
         (if (> colo (+ colo1 8))
             (setq colo colo1)
             (setq colo (1+ colo)))
         (setq angg (+ angg (/ pi numa 0.5))))
 (princ))
 ; Ŀ
 ;   Olaf end.                                                             
 ; 

 ; Ŀ
 ;   Prang - make sure that an angle is between 0 and 2 x pi.              
 ;   Argument: Angg, and angle in radians.                                 
 ;   Returns an angle in radians between 0 and 2Pi.                        
 ; 
 (DEFUN PRANG (angg)
;  (if (equal angg (* 2 pi) 0.0001)       ; apparently not required
;      (setq angg 0))
  (setq angg (rem angg (* pi 2)))
  (if (< angg 0)
      (setq angg (+ angg (* pi 2))))
 angg)
 ; Ŀ
 ;   Prang end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Sta - draw an individual grstar                            
 ;   Takes four arguments: top, side length, rotation (radians),           
 ;   and colour.  Returns nothing, but draws a star.                       
 ; 
 (DEFUN STA (pa sidlen rota colo / anginc angg hafang pb)
  (setq anginc (* 1.6 pi))
  (setq angg (+ rota (* 1.6 pi)))
  (setq hafang (* 0.8 pi))
  (repeat 5
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg anginc))
         (setq pa pb)
         (setq pb (polar pa angg sidlen))
         (grdraw pa pb colo)
         (setq angg (- angg hafang))
         (setq pa pb))
 (princ))
 ; Ŀ
 ;   Subroutine Sta end.                                                   
 ; 

 ; Ŀ
 ;   Brc.                                                                  
 ;   Calls Prang, which may or may not be required.                        
 ;   Also temporary graphic routines Goto and Olaf/Sta.                    
 ;   Graphics can be turned off by setting the global var Nograp to t.     
 ; 
 (DEFUN C:BRC (/ blip oss *error* radi p1 p2 pa ang12 lena pxp px1 ang1 px2
                                   ang2 angba angab pb disa l1a l1b l2b l2a)
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq oss (getvar "osmode"))
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" oss)
   (setvar "blipmode" blip)
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Use an arc radius of 2.5 x dimscale.                                  
 ; 
  (setq radi (* (misps) 2.5))
 ; Ŀ
 ;   Get the required points.                                              
 ; 
  (setq p1 (getpoint "First end: "))
  (setq p2 (getpoint p1 "Second end: "))
 ; Ŀ
 ;   Mark the start end and base line.                                     
 ; 
  (if (null nograp)
      (olaf p1 (* 1.25 radi) 0.1 0 120 9))
  (grdraw p1 p2 -1 1)
 ; Ŀ
 ;   Decide which direction to open in.                                    
 ; 
  (setq pa (polar p1 (setq ang12 (angle p1 p2))
                     (/ (setq lena (distance p1 p2)) 2)))
  (setq pxp (getpoint pa "Open Direction: "))
  (setq px1 (polar pa (setq ang1 (+ ang12 (/ pi 2))) 12))
  (setq px2 (polar pa (setq ang2 (- ang12 (/ pi 2))) 12))
  (if (null nograp) (goto px2 px1 4 1))
  (if (< (distance px1 pxp) (distance px2 pxp))
      (setq angba ang1)
      (setq angba ang2))
  (setq angba (prang angba))
 ; Ŀ
 ;   And save the closed direction angle.                                  
 ; 
  (setq angab (+ angba pi))
  (setq angab (prang angab))
 ; Ŀ
 ;   Adjust the arc radius if there isn't room.                            
 ; 
  (if (< lena (* radi 4))
      (setq radi (/ lena 4)))
 ; Ŀ
 ;   Find the bracket vertex point.                                        
 ; 
  (setq pb (polar pa angab (* 2 radi)))
  (if (null nograp)
      (olaf pb (* radi 0.75) 0.1 0 140 9))
 ; Ŀ
 ;   Draw some debug graphics.                                             
 ;   Angab is the line from pa towards pb, that is towards the closed      
 ;   side.  The open direction is Angba.                                   
 ; 
  (if (null nograp)
      (progn
  (goto pb (polar pb angab (* radi 6)) 2 0) ; yellow line from pb in closed dir
  (goto pa (polar pa angba (* radi 6)) 1 0)   ; red line from pa in open dir
  (goto p1 (polar p1 angab (* 2 radi)) 2 0)   ; yellow = closed
  (goto p1 (polar p1 angba (* 2 radi)) 1 0))) ; red = open
 ; Ŀ
 ;   Unmark the base line.                                                 
 ; 
  (if nograp (grdraw p1 p2 -1 1))
 ; Ŀ
 ;   Find various points on the bracket.                                   
 ;   Already have: P1 = start point for bracket, P2 = other end.           
 ; 
  (setq disa (- (/ lena 2) (* radi 2)))                ; straight length
  (setq l1a (polar (polar p1 ang12 radi) angab radi))  ; start of first line
  (setq l1b (polar l1a ang12 disa))                    ; end of first line
  (setq l2b (polar l1b ang12 (* radi 2)))              ; start of second line
  (setq l2a (polar l2b ang12 disa))                    ; end of second line
 ; Ŀ
 ;   Draw the bracket.                                                     
 ; 
 (setvar "osmode" 0)
 (if (zerop disa)
      (command "pline" p1 "arc" "d" (* angab (/ 180 pi)) l1a
                          "arc" pb
                          "arc" "d" (* angba (/ 180 pi)) l2b
                          "arc" "d" (* ang12 (/ 180 pi)) p2 "")
      (command "pline" p1 "arc" "d" (* angab (/ 180 pi)) l1a
                          "line" l1b
                          "arc" pb
                          "arc" "d" (* angba (/ 180 pi)) l2b
                          "line" l2a
                          "arc" "d" (* ang12 (/ 180 pi)) p2 ""))
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))

 ; Ŀ
 ;   Brac - Bracket drawer.                                                
 ;   Self contained.                                                       
 ; 
 (DEFUN C:BRAC (/ *error* blip oss pa pk xpa ypa xpk ypk verti horiz radi
                                 height angg p2 p3 p4 p5 p6 p7 p8 p9 p10 p11)
  (setvar "cmdecho" 0)
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
  (setq oss (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Try to load Misps.lsp, which contains the subroutines for scaling     
 ;   differently in model and paper space.                                 
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Make an error handler.                                                
 ; 
  (defun *error* (shk)
   (setvar "osmode" oss)
   (setvar "blipmode" blip)
   (if shk (print shk))
  (princ))
 ; Ŀ
 ;   Do some other stuff.                                                  
 ; 
  (setq pa (getpoint "Centre point: "))
  (setq pk (getcorner pa "Half outline: "))  ; becomes start point of pline
  (setq xpa (car pa))
  (setq ypa (cadr pa))
  (setq xpk (car pk))
  (setq ypk (cadr pk))
  (setq verti (abs (- ypk ypa)))
  (setq horiz (abs (- xpk xpa)))
  (if (> horiz verti)
      (progn
          (setq radi (/ verti 2))
          (setq height horiz)
          (if (> ypk ypa)
              (progn
                  (setq angg (/ pi 2))
                  (if (> xpk xpa)
                      (setq pk (polar pk (+ angg (/ pi 2)) (* 2 height)))))
              (progn
                  (setq angg (* pi 1.5))
                  (if (< xpk xpa)
                      (setq pk (polar pk (+ angg (/ pi 2)) (* 2 height)))))))
      (progn
          (setq radi (/ horiz 2))
          (setq height verti)
          (if (> xpk xpa)
              (progn
                  (setq angg 0)
                  (if (< ypk ypa)
                      (setq pk (polar pk (+ angg (/ pi 2)) (* 2 height)))))
              (progn
                  (setq angg pi)
                  (if (> ypk ypa)
                      (setq pk (polar pk (+ angg (/ pi 2)) (* 2 height))))))))
  (setq p2 (polar pk (+ angg (* pi 1.5)) radi))  ; centre of first arc
  (setq p3 (polar p2 (+ angg pi) radi))          ; arc end, line start
  (setq p4 (polar p3 (+ angg (* pi 1.5)) (- height (* 2 radi)))) ; line end
  (setq p5 (polar p4 (+ angg pi) radi))          ; 2nd arc centre
  (setq p6 (polar p5 (+ angg (* pi 1.5)) radi))  ; midpoint
  (setq p7 (polar p6 (+ angg (* pi 1.5)) radi))  ; 3rd arc centre
  (setq p8 (polar p7 angg radi))                 ; 3rd arc end, 2nd line start
  (setq p9 (polar p8 (+ angg (* pi 1.5)) (- height (* 2 radi)))) ; line end
  (setq p10 (polar p9 angg radi))                ; 4th arc centre
  (setq p11 (polar p10 (+ angg (* pi 1.5)) radi)); final arc end
  (command "pline" pk "arc" "ce" p2 p3
                      "line" p4
                      "arc" "a" "-90" p6 "a" "-90" p8
                      "line" p9
                      "arc" "ce" p10 p11 "")
 ; Ŀ
 ;   End neatly.                                                           
 ; 
  (*error* ())
 (princ))